// priority: 29

let 逻辑锁状态NBT键_方块 = "MDF_lock";
let 原始战利品表NBT键_方块 = "MDF_loots_table";
let 指令控制_宝箱锁定_全局启用键 = "chestLockingEnabled_global";
let 指令控制_宝箱锁定_全局锁定键 = "chestLockingLocked";
let 指令控制_宝箱锁定_个人启用键 = "chestLockingEnabled_personal";

BlockEvents.rightClicked(e => {
    let { block: 方块, player: p, level: 世界KJS, server: s } = e;
    let pDATA = p.persistentData;
    let sDATA = s.persistentData;

    if (p.isSpectator() || p.isCreative()) {
        return;
    }

    let 宝箱锁定最终是否生效 = false;
    let 全局规则已锁定 = sDATA.contains(指令控制_宝箱锁定_全局锁定键) && sDATA.getBoolean(指令控制_宝箱锁定_全局锁定键);

    if (全局规则已锁定) {
        if (sDATA.contains(指令控制_宝箱锁定_全局启用键)) {
            宝箱锁定最终是否生效 = sDATA.getBoolean(指令控制_宝箱锁定_全局启用键);
        } else {
            宝箱锁定最终是否生效 = false;
        }
    } else {
        if (pDATA.contains(指令控制_宝箱锁定_个人启用键)) {
            宝箱锁定最终是否生效 = pDATA.getBoolean(指令控制_宝箱锁定_个人启用键);
        } else {
            宝箱锁定最终是否生效 = false;
        }
    }

    if (!宝箱锁定最终是否生效) {
        return;
    }

    if (!(方块.id.includes("chest") || 方块.id.includes("barrel"))) {
        return;
    }

    let 原生方块实体 = null;
    let 原生世界 = null;

    if (世界KJS && 世界KJS.minecraftLevel) {
        原生世界 = 世界KJS.minecraftLevel;
    } else {
        try {
            原生世界 = s.getLevel(方块.dimension);
        } catch (获取世界错误) {
            return;
        }
    }

    if (!原生世界) {
        return;
    }

    let 当前方块KJS坐标 = 方块.pos;

    try {
        原生方块实体 = 原生世界.getBlockEntity(当前方块KJS坐标);
    } catch (获取实体错误) {
        return;
    }

    if (!原生方块实体) {
        return;
    }

    let 持久化数据标签 = 原生方块实体.getPersistentData();
    let 根NBT作识别用 = 原生方块实体.saveWithoutMetadata();
    let 当前箱子战利品表ID = null;

    if (根NBT作识别用.contains("LootTable", 8)) {
        当前箱子战利品表ID = 根NBT作识别用.getString("LootTable");
    } else if (持久化数据标签.contains(原始战利品表NBT键_方块, 8)) {
        当前箱子战利品表ID = 持久化数据标签.getString(原始战利品表NBT键_方块);
    }

    if (!当前箱子战利品表ID) {
        return;
    }

    let 箱子特定配置 = 受管理的战利品箱子配置[当前箱子战利品表ID];

    if (!箱子特定配置) {
        return;
    }

    let 当前逻辑锁状态_方块 = null;
    if (持久化数据标签.contains(逻辑锁状态NBT键_方块, 1)) {
        当前逻辑锁状态_方块 = 持久化数据标签.getBoolean(逻辑锁状态NBT键_方块);
    }

    if (当前逻辑锁状态_方块 === false) {
        return;
    }

    let 半径XZ = 10.0;
    let 半径Y = 4.0;
    let 玩家X = p.x;
    let 玩家Y = p.y;
    let 玩家Z = p.z;
    let 玩家眼睛高度 = p.eyeHeight;

    if (typeof 玩家X !== "number" || isNaN(玩家X) ||
        typeof 玩家Y !== "number" || isNaN(玩家Y) ||
        typeof 玩家Z !== "number" || isNaN(玩家Z) ||
        typeof 玩家眼睛高度 !== "number" || isNaN(玩家眼睛高度)) {
        e.cancel();
        return;
    }

    let 搜索区域KJS = AABB.of(玩家X - 半径XZ, 玩家Y - 半径Y, 玩家Z - 半径XZ, 玩家X + 半径XZ, 玩家Y + 半径Y + 玩家眼睛高度, 玩家Z + 半径XZ);

    let 全部实体列表KJS = [];
    try {
        全部实体列表KJS = 世界KJS.getEntitiesWithin(搜索区域KJS);
    } catch (获取实体错误) {
        e.cancel();
        return;
    }

    let 导致锁定的实体列表 = [];
    let 当前提示信息 = "";
    let 已被特定生物列表锁定 = false;

    if (箱子特定配置.生物列表 && 箱子特定配置.生物列表.length > 0) {
        let 待检查的生物类型 = new Set(箱子特定配置.生物列表);

        for (let 生物类型Id of 待检查的生物类型) {
            let 存活实例列表 = 全部实体列表KJS.filter(实体 => 实体.type === 生物类型Id && 实体.isAlive() && !实体.isSpectator());
            if (存活实例列表.length > 0) {
                已被特定生物列表锁定 = true;
                导致锁定的实体列表.push.apply(导致锁定的实体列表, 存活实例列表);
            }
        }
        if (已被特定生物列表锁定) {
            当前提示信息 = 箱子特定配置.提示信息 || "你需要清除守护宝箱的特定生物！";
        }
    }

    if (!已被特定生物列表锁定) {
        let 附近通用敌对生物列表 = 全部实体列表KJS.filter(实体 =>
            实体.isMonster() &&
            实体.isAlive() &&
            !实体.isSpectator()
        );
        if (附近通用敌对生物列表.length > 0) {
            当前提示信息 = 箱子特定配置.提示信息 || "附近有危险！清除所有敌对生物才能打开宝箱！";
            导致锁定的实体列表.push.apply(导致锁定的实体列表, 附近通用敌对生物列表);
        }
    }

    if (导致锁定的实体列表.length > 0) {
        p.tell(Text.red(当前提示信息));
        new Set(导致锁定的实体列表).forEach(危险实体 => {
            危险实体.potionEffects.add("minecraft:glowing", 200, 0, false, false);
        });

        if (当前逻辑锁状态_方块 === null) {
            p.tell(Text.yellow("这个宝箱现在已被魔法封印，直到周围安全。"));

            持久化数据标签.putBoolean(逻辑锁状态NBT键_方块, true);
            if (根NBT作识别用.contains("LootTable", 8) && !持久化数据标签.contains(原始战利品表NBT键_方块, 8)) {
                持久化数据标签.putString(原始战利品表NBT键_方块, 根NBT作识别用.getString("LootTable"));
            }
            原生方块实体.setChanged();
            原生世界.sendBlockUpdated(当前方块KJS坐标, 原生方块实体.getBlockState(), 原生方块实体.getBlockState(), 3);
        }
        e.cancel();
        return;

    } else {
        if (当前逻辑锁状态_方块 === null || 当前逻辑锁状态_方块 === true) {
            p.tell(Text.green("周围安全，宝箱已解锁！"));
            持久化数据标签.putBoolean(逻辑锁状态NBT键_方块, false);
            if (根NBT作识别用.contains("LootTable", 8) && !持久化数据标签.contains(原始战利品表NBT键_方块, 8)) {
                持久化数据标签.putString(原始战利品表NBT键_方块, 根NBT作识别用.getString("LootTable"));
            }
            原生方块实体.setChanged();
            原生世界.sendBlockUpdated(当前方块KJS坐标, 原生方块实体.getBlockState(), 原生方块实体.getBlockState(), 3);
        }
        return;
    }
});